/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.blockentities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfyu.meadow.block.CookingCauldronBlock;
import net.satisfyu.meadow.client.screen.handler.CookingCauldronGuiHandler;
import net.satisfyu.meadow.recipes.cooking.CookingCauldronRecipe;
import net.satisfyu.meadow.registry.BlockEntityRegistry;
import net.satisfyu.meadow.registry.RecipeRegistry;
import net.satisfyu.meadow.registry.TagRegistry;
import org.jetbrains.annotations.Nullable;

public class CookingCauldronBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);
    private static final int MAX_CAPACITY = 7;
    public static final int MAX_COOKING_TIME = 600;
    private int cookingTime;
    public static final int OUTPUT_SLOT = 0;
    private static final int INGREDIENTS_AREA = 6;
    private boolean isBeingBurned;
    private final ContainerData delegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CookingCauldronBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingCauldronBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CookingCauldronBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingCauldronBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CookingCauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.COOKING_CAULDRON.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.cookingTime = nbt.m_128451_("CookingTime");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("CookingTime", this.cookingTime);
    }

    public boolean isBeingBurned() {
        if (this.m_58904_() == null) {
            throw new NullPointerException("Null world invoked");
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)CookingCauldronBlock.HANGING)).booleanValue()) {
            return true;
        }
        BlockState belowState = this.m_58904_().m_8055_(this.m_58899_().m_7495_());
        Optional optionalList = Registry.f_122824_.m_203431_(TagRegistry.ALLOWS_COOKING);
        HolderSet.Named entryList = optionalList.orElse(null);
        if (entryList == null) {
            return false;
        }
        return entryList.m_203333_((Holder)belowState.m_60734_().m_204297_());
    }

    private boolean canCraft(CookingCauldronRecipe recipe) {
        if (recipe == null || recipe.m_8043_().m_41619_()) {
            return false;
        }
        if (this.m_8020_(0).m_41619_()) {
            return true;
        }
        ItemStack recipeOutput = recipe.m_8043_();
        ItemStack outputSlotStack = this.m_8020_(0);
        int outputSlotCount = outputSlotStack.m_41613_();
        if (!outputSlotStack.m_41656_(recipeOutput)) {
            return false;
        }
        if (outputSlotCount < this.m_6893_() && outputSlotCount < outputSlotStack.m_41741_()) {
            return true;
        }
        return outputSlotCount < recipeOutput.m_41741_();
    }

    private void craft(CookingCauldronRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_();
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(0, recipeOutput.m_41777_());
        } else if (outputSlotStack.m_150930_(recipeOutput.m_41720_())) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        boolean[] slotUsed = new boolean[6];
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            ItemStack bestSlot;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.test(bestSlot = this.m_8020_(i + 1)) && !slotUsed[i]) {
                slotUsed[i] = true;
                bestSlot.m_41774_(1);
                continue;
            }
            for (int j = 1; j <= 6; ++j) {
                ItemStack stack = this.m_8020_(j);
                if (!ingredient.test(stack) || slotUsed[j]) continue;
                slotUsed[j] = true;
                stack.m_41774_(1);
            }
        }
    }

    public void tick(Level world, BlockPos pos, BlockState state, CookingCauldronBlockEntity blockEntity) {
        if (world.m_5776_()) {
            return;
        }
        this.isBeingBurned = this.isBeingBurned();
        if (!this.isBeingBurned) {
            if (((Boolean)state.m_61143_((Property)CookingCauldronBlock.LIT)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        CookingCauldronRecipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.COOKING.get(), (Container)this, world).orElse(null);
        boolean canCraft = this.canCraft(recipe);
        if (canCraft) {
            ++this.cookingTime;
            if (this.cookingTime >= 600) {
                this.cookingTime = 0;
                this.craft(recipe);
            }
        } else if (!this.canCraft(recipe)) {
            this.cookingTime = 0;
        }
        if (canCraft) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if (((Boolean)state.m_61143_((Property)CookingCauldronBlock.COOKING)).booleanValue()) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if ((Boolean)state.m_61143_((Property)CookingCauldronBlock.LIT) != this.isBeingBurned) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public Component m_5446_() {
        return Component.m_130674_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new CookingCauldronGuiHandler(syncId, inv, this, this.delegate);
    }
}

